// PCanIsoTpExampleTabCtrl.cpp : implementation file
//
#include "stdafx.h"

// CPCanIsoTpExampleTabCtrl
#ifdef _DEBUG
#define new DEBUG_NEW
#endif

IMPLEMENT_DYNAMIC(CPCanIsoTpExampleTabCtrl, CTabCtrl)

CPCanIsoTpExampleTabCtrl::CPCanIsoTpExampleTabCtrl(TPCANTPHandle *p_pctpHandle)
{
	m_Parameters = new CPCanIsoTpExampleDlgParameters(p_pctpHandle);
	m_Mappings = new CPCanIsoTpExampleDlgMappings(p_pctpHandle);
	m_Messages = new CPCanIsoTpExampleDlgMessages(p_pctpHandle);
	m_DialogID[0] = IDD_PCANISOTPEXAMPLE_TAB_PARAMETERS;
	m_DialogID[1] = IDD_PCANISOTPEXAMPLE_TAB_MAPPINGS;
	m_DialogID[2] = IDD_PCANISOTPEXAMPLE_TAB_MESSAGES;
}

CPCanIsoTpExampleTabCtrl::CPCanIsoTpExampleTabCtrl()
{
}


BEGIN_MESSAGE_MAP(CPCanIsoTpExampleTabCtrl, CTabCtrl)
	ON_NOTIFY_REFLECT(TCN_SELCHANGE, &CPCanIsoTpExampleTabCtrl::OnTcnSelchange) 
END_MESSAGE_MAP()


//This function creates the Dialog boxes once
void CPCanIsoTpExampleTabCtrl::InitDialogs(TPCANTPHandle *p_pctpHandle)
{
	m_Parameters = new CPCanIsoTpExampleDlgParameters(p_pctpHandle);
	m_Mappings = new CPCanIsoTpExampleDlgMappings(p_pctpHandle);
	m_Messages = new CPCanIsoTpExampleDlgMessages(p_pctpHandle);
	m_DialogID[0] = IDD_PCANISOTPEXAMPLE_TAB_PARAMETERS;
	m_DialogID[1] = IDD_PCANISOTPEXAMPLE_TAB_MAPPINGS;
	m_DialogID[2] = IDD_PCANISOTPEXAMPLE_TAB_MESSAGES;

	m_Dialog[0] = m_Parameters; 
	m_Dialog[1] = m_Mappings; 
	m_Dialog[2] = m_Messages;

	m_nPageCount = 3;

	m_Dialog[0]->Create(m_DialogID[0], GetParent());
	m_Dialog[1]->Create(m_DialogID[1], GetParent());
	m_Dialog[2]->Create(m_DialogID[2], GetParent());
}


// CPCanIsoTpExampleTabCtrl message handlers
void CPCanIsoTpExampleTabCtrl::ActivateTabDialogs()
{
	int nSel = GetCurSel();
	if (m_Dialog[nSel]->m_hWnd)
		m_Dialog[nSel]->ShowWindow(SW_HIDE);

	CRect l_rectClient;
	CRect l_rectWnd;
 
	GetClientRect(l_rectClient);
	AdjustRect(FALSE, l_rectClient);
	GetWindowRect(l_rectWnd);
	GetParent()->ScreenToClient(l_rectWnd);
	l_rectClient.OffsetRect(l_rectWnd.left, l_rectWnd.top);
	// Set position and hide dialogs
	for (int nCount = 0; nCount < m_nPageCount; nCount++) {
		m_Dialog[nCount]->SetWindowPos(&wndTop, l_rectClient.left - 10, l_rectClient.top - 4, l_rectClient.Width() + 10, l_rectClient.Height() + 20, SWP_HIDEWINDOW);
	}
	// Show selected dialog
	m_Dialog[nSel]->SetWindowPos(&wndTop, l_rectClient.left - 10, l_rectClient.top - 4, l_rectClient.Width() + 10, l_rectClient.Height() + 20, SWP_SHOWWINDOW);

	m_Dialog[nSel]->ShowWindow(SW_SHOW);

}

/// <summary>
/// Event called when dialog is closed, it destroys all tabs.
/// </summary>
void CPCanIsoTpExampleTabCtrl::PostNcDestroy()
{
	if (m_Parameters != NULL)
	{
		m_Parameters->DestroyWindow();
	}
	if (m_Mappings != NULL)
	{
		m_Mappings->DestroyWindow();
	}
	if (m_Messages != NULL)
	{
		m_Messages->DestroyWindow();
	}
	CTabCtrl::PostNcDestroy();
	delete this;
}


void CPCanIsoTpExampleTabCtrl::OnTcnSelchange(NMHDR *pNMHDR, LRESULT *pResult)
{
	ActivateTabDialogs();
	*pResult = 0;
}
